package w83b.w83bOperacionesPaso.w83bListados.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


import w83b.w83bBeans.W83bListadosBean;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;

import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaResolDenegatoriasExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String strRutaExcel;
        List listaResolDenegatorias = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
        
        if ("1".equals(listadoBean.getOpcionListResolden())){
        	strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListResolDenegFaltaPre.xls";
		 }
        else{
        	strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListResolDenegatorias.xls";
        }
        
        InputStream inputStream = W83bTablaResolDenegatoriasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
 
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)4);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
       tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)4);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
      
        //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)2); 
        if(StringUtils.isNotEmpty(listadoBean.getDescTerritorio())){
        	cell.setCellValue(listadoBean.getDescTerritorio().toUpperCase());
        }
       
        if ("1".equals(listadoBean.getOpcionListResolden())){
        	cell = row.getCell((short)3); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.motDenegacion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.motDenegacion",W83bClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.getCell((short)4); 
            cell2 = row.getCell((short)5); 
            sheet.addMergedRegion(new Region((short)11,(short)4,(short)11,(short)5)); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.motden1",idioma).toUpperCase());
        }
        else{
        	cell = row.getCell((short)4); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.motDenegacion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.motDenegacion",W83bClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.getCell((short)6); 
            cell2 = row.getCell((short)7); 
            sheet.addMergedRegion(new Region((short)11,(short)6,(short)11,(short)7)); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.motden2",idioma).toUpperCase());
        } 
        
       
        
        if ("1".equals(listadoBean.getOpcionListResolden())){
        	cell = row.getCell((short)6); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fechaEntradaDesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fechaEntradaDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.getCell((short)8); 
        	cell2 = row.getCell((short)9); 
        	sheet.addMergedRegion(new Region((short)11,(short)8,(short)11,(short)9)); 
        	if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaDesde())){
        		  cell.setCellValue(listadoBean.getFechaEntradaDesde());
        	}
        	cell = row.getCell((short)10); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fechaEntradaHasta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fechaEntradaHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.getCell((short)12); 
        	if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaHasta())){
        		cell.setCellValue(listadoBean.getFechaEntradaHasta());
        	}
        }
        else{
        	cell = row.getCell((short)10); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fDesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.getCell((short)12); 
        	if(StringUtils.isNotEmpty(listadoBean.getFechaLaudo())){
        		cell.setCellValue(listadoBean.getFechaLaudo());
        	}
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)13);
        cell = row.getCell((short)0);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)1);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)2);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preaviso",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preaviso",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)3);
        cell2 = row.getCell((short)4);
        sheet.addMergedRegion(new Region((short)13,(short)3,(short)13,(short)4)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)5);
        cell2 = row.getCell((short)6);
        cell3 = row.getCell((short)7);
        sheet.addMergedRegion(new Region((short)13,(short)5,(short)13,(short)7)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)8);
        cell2 = row.getCell((short)9);
        sheet.addMergedRegion(new Region((short)13,(short)8,(short)13,(short)9)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)10);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)11);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)12);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fImpug",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fImpug",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)13);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fregdef",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fregdef",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
       
        for(int i=0;i<listaResolDenegatorias.size();i++){
        	row = sheet.createRow((short)14+i); // Creacin de la fila 1
        	
        	cell = row.createCell((short)0); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getFechaEntrada())){
        		cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getFechaEntrada());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	StringBuffer sb;
        	sb = new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
        	String valor=W83bUtilidadesComunes.rellenarCeros(((W83bListadosBean)listaResolDenegatorias.get(i)).getNumActa());
        	sb.append(valor);
        	cell = row.createCell((short)1); 
        	cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getTerritorio()+"/"+((W83bListadosBean)listaResolDenegatorias.get(i)).getAnyoActa()+"/"+sb.toString());
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	if (((W83bListadosBean)listaResolDenegatorias.get(i)).getTerritorio()==null){
        		((W83bListadosBean)listaResolDenegatorias.get(i)).setTerritorio("-");
        	}
        	if (((W83bListadosBean)listaResolDenegatorias.get(i)).getAnopreaviso()==null){
        		((W83bListadosBean)listaResolDenegatorias.get(i)).setAnopreaviso("-");
        	}
        	if (((W83bListadosBean)listaResolDenegatorias.get(i)).getNPre()==null){
        		((W83bListadosBean)listaResolDenegatorias.get(i)).setNPre("-");
        	}
        	else{
        	
         			sb = new StringBuffer();//NOPMD
         			valor=W83bUtilidadesComunes.rellenarCeros(((W83bListadosBean)listaResolDenegatorias.get(i)).getNPre());
         			sb.append(valor);
         			((W83bListadosBean)listaResolDenegatorias.get(i)).setNPre(valor);
        	}
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getTerritorio()) 
        			&& StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getAnopreaviso()) 
        			&& StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getNPre())){
        		cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getTerritorio()+"/"+((W83bListadosBean)listaResolDenegatorias.get(i)).getAnopreaviso()+"/"+((W83bListadosBean)listaResolDenegatorias.get(i)).getNPre());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)3); 
        	cell2 = row.createCell((short)4); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)3,(short)14+i,(short)4)); //NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getRazon())){ 
        			cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getRazon().toUpperCase());
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)5); 
        	cell2 = row.createCell((short)6); 
        	cell3 = row.createCell((short)7); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)5,(short)14+i,(short)7)); //NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getDireccion())){ 
        		cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getDireccion().toUpperCase());
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	cell3.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)8); 
        	cell2 = row.createCell((short)9); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)8,(short)14+i,(short)9));//NOPMD 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getMunicipio())){ 
        		cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getMunicipio().toUpperCase());
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)10);
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getNumelectores())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaResolDenegatorias.get(i)).getNumelectores()));
        	}else{
        		cell.setCellValue("");
        	}

        	cell.setCellStyle(estiloFilaNumero(i,excel));
        	
        	cell = row.createCell((short)11);
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getNumrep())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaResolDenegatorias.get(i)).getNumrep()));
        	}else{
        		cell.setCellValue("");
        	}

        	cell.setCellStyle(estiloFilaNumero(i,excel));
  
        	
        	cell = row.createCell((short)12); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getFimpug())){ 
        		cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getFimpug());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)13); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaResolDenegatorias.get(i)).getFregdef())){ 
        		cell.setCellValue(((W83bListadosBean)listaResolDenegatorias.get(i)).getFregdef());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
      
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoResolucionesDenegatorias.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumero;
		}else{
			return excel.styleTextoImparNumero;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}

}
